//Tetrad class, child of GraphicsObject
//Author: Matt Billock

#pragma once
//use the constants given in Math.h
#define _USE_MATH_DEFINES
#include <stdlib.h>
#include "graphicsobject.h"
#include "Square.h"
#include <Math.h>

//declare "tetrad" as a sub class of GraphicsObject
class tetrad :
	public GraphicsObject
{
public:
	tetrad(void);
	~tetrad(void);

  //draw the tetrad
	void draw();
  //move down one square
	bool moveDown();
  //move left one square
	bool moveLeft();
  //move right one square
	bool moveRight();
  //turn a piece in the given direction
	void rotPiece(float direction);
  //set the maximum x/y values
	inline void setMaxBounds(int x, int y){ maxX = x; maxY = y;};
  //return number of bricks in a given row
	int getRowCount(int x);
  //check to see if bottom is hit
	bool moveDone();
  //check to see if two tetrads are coincident
	bool pointInside(tetrad test);
  //set the position of the tetrad
	void setPosition(int x, int y);
  //clear all bricks from a given row
	void clearRow(int x);

  //return the highest point in this piece
  int getMaxY();

  //return the x location of a given square
	inline int getSquareX(int index){ return pieces[index].getX(); };
  //return the y location of a given square
	inline int getSquareY(int index){ return pieces[index].getY(); };

private:
  //store the components
	Square pieces[4];
  //maximum x anbd y values
	int maxX, maxY;
  //positional x and y values (where it is)
	int posX, posY;
  //rotated angle
	int direction;
  //type of piece
	int type;
};
