#include ".\tetrad.h"
#using <mscorlib.dll>

//constructor
tetrad::tetrad(void)
{

  //set the piece entry point
	posX = 5;	posY = 19;

  //not rotated
	direction	=	0;
  //pick one of the seven pieces at (pseudo) random
	type = rand()%7;
  //figure out which piece, and build it from component bricks
	switch(type){
		case 0:	//straight line, red
			pieces[0].setColor(1,0,0);
			pieces[1].setColor(1,0,0);
			pieces[2].setColor(1,0,0);
			pieces[3].setColor(1,0,0);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX,posY-2);
			pieces[3].setPosition(posX,posY-3);
			break;
		case 1://box, green
			pieces[0].setColor(0,1,0);
			pieces[1].setColor(0,1,0);
			pieces[2].setColor(0,1,0);
			pieces[3].setColor(0,1,0);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX+1,posY);
			pieces[3].setPosition(posX+1,posY-1);
			break;
		case 2://z to	right, blue
			pieces[0].setColor(0,0,1);
			pieces[1].setColor(0,0,1);
			pieces[2].setColor(0,0,1);
			pieces[3].setColor(0,0,1);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX+1,posY-1);
			pieces[3].setPosition(posX+1,posY-2);
			break;
		case 3://z to	left, yellow
			pieces[0].setColor(1,1,0);
			pieces[1].setColor(1,1,0);
			pieces[2].setColor(1,1,0);
			pieces[3].setColor(1,1,0);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX-1,posY-1);
			pieces[3].setPosition(posX-1,posY-2);
			break;
		case 4://L to	right, cyan
			pieces[0].setColor(0,1,1);
			pieces[1].setColor(0,1,1);
			pieces[2].setColor(0,1,1);
			pieces[3].setColor(0,1,1);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX,posY-2);
			pieces[3].setPosition(posX+1,posY-2);
			break;
		case 5://L to	left, magenta
			pieces[0].setColor(1,0,1);
			pieces[1].setColor(1,0,1);
			pieces[2].setColor(1,0,1);
			pieces[3].setColor(1,0,1);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX,posY-2);
			pieces[3].setPosition(posX-1,posY-2);
			break;
		case 6://upside	down T, white
			pieces[0].setColor(1,1,1);
			pieces[1].setColor(1,1,1);
			pieces[2].setColor(1,1,1);
			pieces[3].setColor(1,1,1);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX-1,posY-1);
			pieces[3].setPosition(posX+1,posY-1);
			break;
		
	};


}

tetrad::~tetrad(void)
{
}

//draw the piece
void tetrad::draw(){

  //cycle through the components
	for(int	i	=	0; i<4;	i++){
    //if the piece is active, draw it
		if(pieces[i].getDraw())
			pieces[i].draw();
	}

}

//find the number of pieces in each row
int	tetrad::getRowCount(int	x){

  //start with nothing
	int	result = 0;
  //check all four pieces
	for(int	i	=	0; i<4;	i++){
    //if piece is active and is in the row, increment result
		if((pieces[i].getY() ==	x) &&	pieces[i].getDraw())
			result++;
	}
	//return the result
	return result;

}

//clear all pieces from a given row
void tetrad::clearRow(int	x){

  //go through all the pieces
	for(int	i	=	0; i<4;	i++){
    //if a piece is in the row, set it to disabled
		if(pieces[i].getY()	== x){
			pieces[i].setDraw(false);
		}
    //if the piece is active and is above where the old row was
		if(pieces[i].getDraw() &&	pieces[i].getY() > x){
      //move the piece down
			pieces[i].setPosition(pieces[i].getX(),	pieces[i].getY()-1);
		}
	}
}

//set the piece position
void tetrad::setPosition(int x,	int	y){

		posX = x;
		posY = y;

    //up;date all the component squares to the new position
  switch(type){
		case 0:
			pieces[0].setColor(1,0,0);
			pieces[1].setColor(1,0,0);
			pieces[2].setColor(1,0,0);
			pieces[3].setColor(1,0,0);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX,posY-2);
			pieces[3].setPosition(posX,posY-3);
			break;
		case 1:
			pieces[0].setColor(0,1,0);
			pieces[1].setColor(0,1,0);
			pieces[2].setColor(0,1,0);
			pieces[3].setColor(0,1,0);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX+1,posY);
			pieces[3].setPosition(posX+1,posY-1);
			break;
		case 2:
			pieces[0].setColor(0,0,1);
			pieces[1].setColor(0,0,1);
			pieces[2].setColor(0,0,1);
			pieces[3].setColor(0,0,1);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX+1,posY-1);
			pieces[3].setPosition(posX+1,posY-2);
			break;
		case 3:
			pieces[0].setColor(1,1,0);
			pieces[1].setColor(1,1,0);
			pieces[2].setColor(1,1,0);
			pieces[3].setColor(1,1,0);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX-1,posY-1);
			pieces[3].setPosition(posX-1,posY-2);
			break;
		case 4:
			pieces[0].setColor(0,1,1);
			pieces[1].setColor(0,1,1);
			pieces[2].setColor(0,1,1);
			pieces[3].setColor(0,1,1);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX,posY-2);
			pieces[3].setPosition(posX+1,posY-2);
			break;
		case 5:
			pieces[0].setColor(1,0,1);
			pieces[1].setColor(1,0,1);
			pieces[2].setColor(1,0,1);
			pieces[3].setColor(1,0,1);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX,posY-2);
			pieces[3].setPosition(posX-1,posY-2);
			break;
		case 6:
			pieces[0].setColor(1,1,1);
			pieces[1].setColor(1,1,1);
			pieces[2].setColor(1,1,1);
			pieces[3].setColor(1,1,1);
			pieces[0].setPosition(posX,posY);
			pieces[1].setPosition(posX,posY-1);
			pieces[2].setPosition(posX-1,posY-1);
			pieces[3].setPosition(posX+1,posY-1);
			break;
		
	};

}

//check to see if the floow is hit
bool tetrad::moveDone(){

  //for each piece
	for(int	i	=	0; i<4;	i++){
    //check against the bounds
		if(pieces[i].getY()	== maxY)
			return true;
	}
  //s'all good
	return false;
}

//Move down by one piece
bool tetrad::moveDown(){

  //for each piece, move it down one and check to see if it hits the floor
	for(int	j=0; j<4;	j++){
		if(pieces[j].getY()-1	<	0)
      //hits the floor, so don't move
			return false;
	}
	
  //move should work, so have at it
	for(int	i	=	0; i<4;	i++){
		
		pieces[i].setPosition(pieces[i].getX(),	pieces[i].getY()-1);
	}

  //all went well
	return true;

}

//move the tetrad left one space
bool tetrad::moveLeft(){

  //check for move viability
	for(int	j=0; j<4;	j++){
		if(pieces[j].getX()-1	<	0	)
      //move would be out of bounds
			return false;
	}
	
  //all's well ,so let's move
	for(int	i	=	0; i<4;	i++){		
		pieces[i].setPosition(pieces[i].getX()-1,	pieces[i].getY());
	}

  //s'all good
	return true;


}

//check to see if two tetrads are coincident
bool tetrad::pointInside(tetrad	test){

  //check each block in this object against each block in test
	for(int	i	=	0; i<	4; i++){

		for(int	j=0; j<4;	j++){

      //if the pieces are in the same spot
			if((pieces[i].getX() ==	test.getSquareX(j))	&&(	pieces[i].getY() ==	test.getSquareY(j))	&& pieces[i].getDraw()){
        //pieces are coincident
				return true;
			}
		}
	}
  //it's all good
	return false;

}

//move right one spot, same as move left but in the other direction
bool tetrad::moveRight(){

	for(int	j=0; j<4;	j++){
		if(pieces[j].getX()+1	>	9	)
			return false;
	}
	
	for(int	i	=	0; i<4;	i++){
		
		pieces[i].setPosition(pieces[i].getX()+1,	pieces[i].getY());
	}

	return true;


}

//takes	a	+90	or a -90
void tetrad::rotPiece(float	direction){

  //store the center piece
	float	centerX, centerY;
  //convert to radians
	direction	=	direction	*	((2	*	M_PI)	/	360.0);

  //obtain the value of the center (set to the second piece)
	centerX = pieces[1].getX();
	centerY = pieces[1].getY();

  //if the type isn't a box (no point in spinning a box)
	if(type	!= 1){
    //rotate all pieces  by the generic 2D rotation function from the origin
    //note that this function will work for all angles
		for(int	i	=	0; i<4;	i++){
			pieces[i].setPosition((pieces[i].getX()-centerX)	*	cos((float)direction)	
															-	(pieces[i].getY()-centerY)	*	sin((float)direction), 
															(pieces[i].getY()-centerY)	*	cos((float)direction)	+	
															(pieces[i].getX()-centerX)	*	sin((float)direction));

      //relocate the piece to where it should be
			pieces[i].setPosition(centerX + pieces[i].getX(), centerY	+	pieces[i].getY());

		}

    //if the rotation goes outside a wall, reposition the piece in the game area
		for(int i = 0; i< 4; i++){
			if(pieces[i].getX() >= 10){
				for(int j = 0; j<4; j++)
					pieces[j].setPosition(pieces[j].getX()-1, pieces[j].getY());
			}
			if(pieces[i].getX() < 0){
				for(int k = 0; k<4; k++)
					pieces[k].setPosition(pieces[k].getX()+1, pieces[k].getY());
			}
		}
	}
	
}

//return the highest point of the tetrad
int tetrad::getMaxY(){

	int result = 0;

	for(int i = 0; i<4; i++){
		if(pieces[i].getY() > result)
			result = pieces[i].getY();
	}

	return result;

}

