//The Effervescent Tumbling Rock Images, Seriously (T.E.T.R.I.S.)
//Author: Matt Billock

//Get us our includes!
#include <vector> //STL vector structure
#include <gl/glut.h> //Gluth library
#include <iostream> //IO for debugging purposes
#include "GraphicsObject.h" //Graphics base class
#include "Square.h" //Derived graphics object Square
#include "tetrad.h" //The individual pieces

//allow us to use vectors and stuff
using	namespace	std;

//define our objects
vector<GraphicsObject*>	bricks;

//function prototypes
void draw(); //the draw function
void myTimer(int value); //the framerate function
void runGameLogic(); //game logic function
void clearLines(); //check for full lines
void calcHighest(); //find the highest point in the window
void myKey(int key,	int	x, int y); //special key function
void myKey2(unsigned char key,	int	x, int y); //keyboard function

//some global variables
int	x=0; //used in animation
int	level, lines,	count[20]; //hold the level, number of lines, and counts at each level
int	highest	=	0; //store the highest point
tetrad *mine; //the current tetrad being worked with

//this function only really serves one purpose - see if the
//user has tried to quit lately
void myKey2(unsigned char key, int x, int y){

  //if the user presses 'q', quit the program
  if( key == 'q'){
    delete mine;
    exit(0);
  }

}

//calculate the highest point.  If at any point it reaches
//19, the game is over
void calcHighest(){

  //loop through the bricks, finding the highest point in each
	for(int	i=0; i<bricks.size();	i++){
		if(((tetrad	*)bricks[i])->getMaxY()	>	highest)
			highest	=	((tetrad *)bricks[i])->getMaxY();
	}

}

//Detect lines that contain 10 bricks (a full line), and clear them
void clearLines(){

  //loop through the possible number of lines, and determine the number
  //of bricks in each line
	for(int	i=0; i<20; i++){

		count[i] = 0;
		
    //use a tetrad function to determine the nubmer of bricks in each row
    for(int	j=0; j<bricks.size();	j++){
			count[i]+=((tetrad *)bricks[j])->getRowCount(i);
		}
		
    //if this level has ten or more bricks, a line has been created
    if(count[i]	>= 10){
		
      //clear squares in that row for all the currently existing pieces
      for(int	eye	=	0; eye < bricks.size();	eye++)
				((tetrad *)bricks[eye])->clearRow(i);

      //reset the highest variable, as it has just changed
			highest	=	0;

      //increase the line count
			lines++;
      //reset the line count
			count[i] = 0;
      //restart the loop, to detect multiple lines
			i=-1;

      //if a multiple of ten lines has been reached, it's time to go up a level
      if(lines%10	== 0)
				level++;

    }

  }

}

//This takes care of the game logic, making sure everything is run properly
void runGameLogic(){

  //boolean variable used to test movement conditions
	bool works = false;
  //a temporary tetrad to assist in collision detection
	tetrad temp	=	*mine;

  //if the game is able to be played (i.e. if the game hasn't been lost)
	if(highest < 19){

    //move the brick down (to make the game interesting.  otherwise there's no
    //skill required)
		temp.moveDown();

    //check to see if moving the brick down has had any effect
		for(int	k	=0;	k	<	bricks.size(); k++){
			if(((tetrad	*)bricks[k])->pointInside(temp))
				works	=	true; //the brick has passed into another brick
		}
    //as long as it's all good (no collisions
		if(!works){
      //make one more check, against the floor this time
			if(!mine ->	moveDown()){
        //the brick has hit the floor, so it is now a part of the landscape
				bricks.push_back(mine);
        //create a new brick
				mine = new tetrad();
        //check to see if any lines were filled by the addition of this brick
				clearLines();
        //find the highest point
				calcHighest();
			}
		}
    //the brick has hit another brick
		else{
      //the brick is now a part of the landscape
			bricks.push_back(mine);
      //get a new brick
			mine = new tetrad();
      //check to see if any lines were completed
			clearLines();
      //find the highest point
			calcHighest();
		}

	}
  //if the highest point is 20 bricks off the ground, the game is over
	else{

    //print the game over message to the console
		cout<<"Game	Over!	Press	a	key	to exit" <<	endl;

	}

}



void myTimer(int value){

  //store the number of this frame in the cycle
	x++;
	
  //increae the framerate by 5 for every level obtained
  //this emulates acceleration
  if(x >=60-5*level){
		x=x%(60-5*level);
	}

  //if the cycle is at its beginning, run the game logic
  if(x ==	0)
		runGameLogic();

  //tell the program to draw the game
	glutPostRedisplay();

  //reload the timer function, to ensure a looping program
	glutTimerFunc(1000/(60+level*10),	myTimer, x);

}

//this handles the special keys, used for movement
void myKey(int key,	int	x, int y){

  //temporary tetrad for collison detection purposes
	tetrad temp	=	*mine;
  //boolean value used in collision detection
	bool works = false;

  //if the game isn't over
	if(highest < 19){
		switch(key){
      //user has pushed the "Left" arrow
		case GLUT_KEY_LEFT:	//GLUT_KEY_LEFT - 100
      //attempt to move the piece left
			temp.moveLeft();
      //check for collisions
			for(int	i	=0;	i	<	bricks.size(); i++){
				if(((tetrad	*)bricks[i])->pointInside(temp))
					works	=	true;
			}
      //only move the main piece left if it is possible to do so
			if(!works)
				mine ->	moveLeft();
			break;

      //user has pushed the "Up" arrow
		case GLUT_KEY_UP:	//GLUT_KEY_UP - 101

      //attempt to rotate the piece by -90 degrees
      temp.rotPiece(-90);

      //check for collisions
			for(int	i	=0;	i	<	bricks.size(); i++){
				if(((tetrad	*)bricks[i])->pointInside(temp))
					works	=	true;
			}

      //only rotate the piece if it is ok to do so
			if(!works)
				mine ->	rotPiece(-90);
			break;

      //user pressed the "right" arrow
		case GLUT_KEY_RIGHT:	//GLUT_KEY_RIGHT - 102
      //attempt a move right
			temp.moveRight();
      //check for collisions
			for(int	j	=0;	j	<	bricks.size(); j++){
				if(((tetrad	*)bricks[j])->pointInside(temp))
					works	=	true;
			}
      //if it's all good, move right
			if(!works)
				mine ->	moveRight();
			break;

      //user has pushed the "down" arrow
		case GLUT_KEY_DOWN:	//GLUT_KEY_DOWN - 103
      //attempt to move down
			temp.moveDown();
      //check for collisions with other bricks
			for(int	k	=0;	k	<	bricks.size(); k++){
				if(((tetrad	*)bricks[k])->pointInside(temp))
					works	=	true;
			}
      //if it is ok to move down brick-wise
			if(!works){
        //check for a floor hit
				if(!mine ->	moveDown()){
          //floor was hit, so brick is now permanent
					bricks.push_back(mine);
          //create a new brick to work with
					mine = new tetrad();
          //check to see if any lines have been made
					clearLines();
          //find the new highest point
					calcHighest();
				}
			}
      //otherwise, the brick has collided
			else{
        //make brick permanent
				bricks.push_back(mine);
        //create a new brick
				mine = new tetrad();
        //check for lines
				clearLines();
        //find the new highest point
				calcHighest();
			}
			break;
		};

	}
  //game is lost, so user has hit a key to exit
	else{
  
    //release the pointer
    delete mine;
	  //exit the program
		exit(0);
  }

}

//draw our world, in one easy step!
void draw(){

  //clear the screen to prep the frame for drawing
	glClear(GL_COLOR_BUFFER_BIT);

  //begin drawing squares
	glBegin(GL_QUADS);
  //draw the game piece
	mine->draw();

  //draw the rest of the world
	for(int	i	=	0; i<bricks.size();	i++)
		bricks[i]->draw();

  //end the draw phase
	glEnd();

  //flip the image to the screen
	glutSwapBuffers();

}

//main function, where the magic happens
void main	(int argc, char* argv){

  //create the first game piece
	mine = new tetrad();

  //create a window at (100,100) screen coords
	glutInitWindowPosition(100,100);
  //make the window 320 x 640
	glutInitWindowSize(320,640);

  //double-buffered, RGBA display
	glutInitDisplayMode(GLUT_RGBA	|	GLUT_DOUBLE);

  //call this window "T.E.T.R.I.S."
	glutCreateWindow("T.E.T.R.I.S.");

  //register the display function (draw)
	glutDisplayFunc(draw);

  //register the special key function (myKey)
	glutSpecialFunc(myKey);

  //register the standard letter/number function (myKey2)
	glutKeyboardFunc(myKey2);

  //start the timer function
	glutTimerFunc(1000/60,myTimer,0);

  //set the clear color to black
	glClearColor(0,0,0,0);

  //make our window a grid 10 units wide by 20 high
  glOrtho(0,10,0,20, -1, 1);
  
  //clear the screen
	glClear(GL_COLOR_BUFFER_BIT);

  //initialize the level
	level	=	1;

  //start the madness
	glutMainLoop();

	delete mine;

}



