//Graphics Object Class
//Written by: Matt Billock
//Inspired by: Dr. Adrian Sannier, Iowa State University

#pragma once

class GraphicsObject
{
public:
	GraphicsObject(void);

	//translate, rotate, scale
	void xlate();
	void rotate();
	void scale();

	//set this object to draw or not draw
	inline void setDraw(bool tf){ drawMe = tf; }

	//find out if this object is being drawn
	inline bool getDraw(){ return drawMe; }

	//our virtual draw function

	virtual void draw() = 0;

  //set the color of this object to user-defined rgb values
	void setColor(float r2, float g2, float b2);

  //virtual destructor
	virtual ~GraphicsObject(void);

protected:
  //store the color
	float r,g,b;
  //store the drawing state
	bool drawMe;

};
